package org.msh.etbm.services.mobile;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.*;
import org.jboss.seam.security.Identity;
import org.msh.etbm.rest.mobile.SyncCasesRequest;
import org.msh.etbm.services.mobile.model.TbCaseDataRequest;
import org.msh.tb.entities.SynchronizationSummary;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.User;
import org.msh.tb.entities.UserLogin;
import org.msh.utils.date.DateUtils;

import javax.persistence.EntityManager;

/**
 * Created by msantos on 12/2/18.
 */
@Name("syncSummaryService")
@Scope(ScopeType.APPLICATION)
@AutoCreate
public class SyncSummaryService {

    @In
    EntityManager entityManager;

    /**
     * Creates a summary about the synchronization in progress
     * @param unit the unit being sync
     * @param req the synchronization detail
     */
    @Transactional
    public void createSummary(Tbunit unit, SyncCasesRequest req) {
        int casesCreated = 0;
        int casesUpdated = 0;

        for (TbCaseDataRequest data : req.getCases()) {
            if(data.getServerId() == null) {
                casesCreated++;
            } else {
                casesUpdated++;
            }
        }

        User user = getUser();

        SynchronizationSummary s = new SynchronizationSummary();
        s.setExecDate(DateUtils.getDate());
        s.setTbunit(unit);
        s.setWorkspace(unit.getWorkspace());
        s.setUserName(user.getName());
        s.setUserLogin(user.getLogin());
        s.setTbcasesCreated(casesCreated);
        s.setTbcasesUpdated(casesUpdated);

        entityManager.persist(s);
        entityManager.flush();
    }

    /**
     * Returns the logged user
     * @return
     */
    public User getUser() {
        UserLogin userLogin = (UserLogin) Component.getInstance("userLogin");
        return entityManager.find(User.class, userLogin.getUser().getId());
    }
}
